#!/bin/bash
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# Restricted Materials of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
####################################################################
#
#   chswnm command
#
#   Syntax:  chswnm [ -a | -c | -d | -q | -r | -v
#                             | --help ] 
#
#            --help   - Prints this message
#            -a       - Used to activate the SNM software by uncommenting the
#                          /etc/inittab entry for startFNMD
#            -c       - Used to rewrite /var/hsc/log/fnmhw.cfg to .old and /etc/inittab 
#			   to start startFNMD -h.  Polls waiting for /var/hsc/log/fnmhw.cfg 
#		           to be created.  If timeout, calls the -d code to terminate fnmd.
#            -d       - Used to deactivate the SNM software by commenting out 
#                          the /etc/inittab entry for startFNMD
#            -q       - Used to query the activation status of the SNM software
#                          by examining the /etc/inittab entry for startFNMD
#            -r       - Used by RestoreSNMUpgradeData to uncomment the
#                          /etc/inittab entry for startFNMD
#	     -v	      - Used to add -V to startFNMD and execute
#
####################################################################
#
#   Initial version - 02/26/03
#
####################################################################
#"@(#)35   1.11   src/hmcpok/commands/chswnm.bash, fnm.websm, hmcpok_rel3, rel30436a 8/23/04 11:10:47"

PRGRM="chswnm"
AFLAG=0
CFLAG=0
DFLAG=0
QFLAG=0
RFLAG=0
VFLAG=0
HFLAG=0

USAGE="Syntax:  chswnm [ -a | -c | -d | -q | -r | -v | -h | --help ] \n
            -h | --help   - Prints this message \n
            -a       - Used to activate the SNM software by uncommenting the \n\t
                          /etc/inittab entry for startFNMD \n
            -c       - Used to rewrite /var/hsc/log/fnmhw.cfg to .old and /etc/inittab \n\t
                          to start startFNMD -h.  Polls waiting for /var/hsc/log/fnmhw.cfg \n\t
                          to be created.  If timeout, calls the -d code to terminate fnmd. \n
            -d       - Used to deactivate the SNM software by commenting out \n\t
                          the /etc/inittab entry for startFNMD \n
            -q       - Used to query the activation status of the SNM software \n\t
                          by examining the /etc/inittab entry for startFNMD \n
            -r       - Used by RestoreSNMUpgradeData to uncomment the \n\t
                          /etc/inittab entry for startFNMD \n
            -v       - Used to add -V to startFNMD and execute\n"

# First check for existence of parameters, then check validity
if (( $# != 1 ))
then
	echo -e $USAGE 
	exit 2
else
    while test -n "$1"
        do
            case $1 in
                -a) AFLAG=1; break;;
		-c) CFLAG=1; break;;
                -d) DFLAG=1; break;;
                -q) QFLAG=1; break;;
                -r) RFLAG=1; break;;
		-v) VFLAG=1; break;;
		-h) HFLAG=1; break;;
		--help) HFLAG-1; break;;
                 *) echo -e $USAGE; exit 2;;
            esac
        done
fi

# Now make sure we are executing cut from the right path.  IN RedHat, it is
#   in /bin.  In MCP, it is in /usr/bin
if [[ -a /bin/cut ]]
then
	CUT=/bin/cut
else
	CUT=/usr/bin/cut
fi

# For -h, we query the usage statement
if [ $HFLAG -eq 1 ]
then
 
	echo -e $USAGE;
	exit 2;

fi


# For -q, we query whether or not SNM software is enabled in /etc/inittab
if [ $QFLAG -eq 1 ]
then
	# First verify that /opt/hsc/data/fnmSwConfig exits 
	if [[ ! -f /opt/hsc/data/fnmSwConfig ]]
        then
		# File does not exist
		echo 2;
		echo fnmSwConfig does not exis, exiting...;
		exit 2;
	fi	  


        cat_result=`/bin/cat /opt/hsc/data/fnmSwConfig | /usr/bin/wc -w`	
	if [ $cat_result -ne 3 ]
	then
		# fnmSwConfig doest not have the correct format
		# Delete file
		echo 2;
		/bin/rm /opt/hsc/data/fnmSwConfig
		echo fnmSwConfig file does not have the correct format, Deleting ...;
		exit 2;
	fi
	
	# Perform the query function
	grep_results=`/bin/grep startFNMD /etc/inittab`
	if [[ $grep_results == "" ]]
	then
		# No entry in /etc/inittab - should not happen
		echo 4;
		echo No entry in /etc/inittab for startFNMD, exiting ...;
		exit 4
	fi

	first_char=`echo $grep_results | $CUT -c 1`	#grap first char when grepping for fnmd
	if [[ $first_char == "f" ]]			#if first char is an f then daemon activated
	then
		# SNM software is activated
		first_char=`echo $grep_results | $CUT -c 43`	#cut 43 characters out to check what mode
		if [[ $first_char == "h" ]]			#if startFNMD -h then exit
		then 
			echo 3;
			echo startFNMD -h activated, preparing to exit ...;
			exit 3;
	        fi
                  
	        num_grep_lines=`/bin/ps -ef | /bin/grep -c "/opt/hsc/bin/fnmd"`	#if not -h then grep number of threads
        
                if [ $num_grep_lines -gt 4 ]			#if threads = 4 then we are good
                then
                       let up=1
                else
			echo 3;
			echo Not enough threads activated exiting ...;
			exit 3;
		fi
		
		echo 0;
		echo SNM software is activated; 
		exit 0
	else							#if daemon deactivated then exit
		# SNM software is de-activated
		echo "1"
		echo SNM software is de-activated;
		exit 1
	fi
fi

# For -c we startFNMD -h and wait for the fnmhw.cfg file to be created. 
if [ $CFLAG -eq 1 ]
then
	grep_results=`/bin/grep startFNMD /etc/inittab`		#grep 'startFNMD' in /etc/inittab
        if [[ $grep_results == "" ]]				#if not there, error
        then
                # No entry in /etc/inittab - should not happen
                echo 4;
		echo No entry in /etc/inittab for startFNMD, exiting ...;
                exit 4 
        fi

	first_char=`echo $grep_results | $CUT -c 1`		#if so pipe result and cut first char
        if [[ $first_char == "f" ]]				#if 'f' software enabled already
        then
                # SNM software is activated already
                echo "1"
		echo SNM software is activated already exiting ...;
                exit 1
        else
		/bin/rm -f /opt/hsc/data/.fnmhw 1>/dev/null 2>&1	#if daemon deactivated then remvove the fnmhw file

                # SNM software is de-activated - need to activate it
                # First remove the entry from /etc/inittab
                /bin/sed -e '/fnmd:/d' /etc/inittab > /tmp/hsc_tmp_inittab

                # Now add the uncommented entry and mv the file back
                echo "fnmd:2345:respawn:/opt/hsc/bin/startFNMD -h 1>/dev/null 2>&1" >> /tmp/hsc_tmp_inittab
                /bin/mv /tmp/hsc_tmp_inittab /etc/inittab

                # Cause the file to be re-examined
                /sbin/telinit q

		# Now we wait
                # Use end as the while loop ending indicator, up is the
                #      signal that the daemon is up, and count will track
                #      how many sleep 5's we do.  If we get to 60, that's
                #      five minutes, and that's too long.
                end=0
                up=0
                count=0
                while test $end -eq 0
                do
                        sleep 5
                        cfg_file_up=`/bin/ls /opt/hsc/data/.fnmhw 2>/dev/null`	#grep for cfg file to appear
                        if [[ $cfg_file_up != "" ]]				#if so  then set flag
                        then
                                        let up=$up+1
                        fi
                        let  count=$count+1					#bump counter
                        if (($count == 60 || $up == 1))				#if flag set or timeout end
                        then
                                end=1
                        fi
                done

                if (($count == 60))						#if timeout
                then
                        # We exited because 5 minutes are up
                        #Perform the de-activate function - first see if it is already de-activated
        		grep_results=`/bin/grep startFNMD /etc/inittab`
        		if [[ $grep_results == "" ]]
        		then
                		# No entry in /etc/inittab - should not happen
                		echo 4;
				echo No entry in /etc/inittab - should not happen;
                		exit 4 
        		fi

        		first_char=`echo $grep_results | $CUT -c 1`
        		if [[ $first_char == "#" ]]
        		then
                		# SNM software is de-activated already
                		echo "2"	
				echo SNM software is de-activated already; 
                		exit 2 
        		else
                		# SNM software is activated - need to de-activate it
                		# First remove the entry from /etc/inittab
                		/bin/sed -e '/^fnmd:/d' /etc/inittab > /tmp/hsc_tmp_inittab

                		# Now add the commented entry and mv the file back
                		echo "#fnmd:2345:respawn:/opt/hsc/bin/startFNMD 1>/dev/null 2>&1" >> /tmp/hsc_tmp_inittab
                		/bin/mv /tmp/hsc_tmp_inittab /etc/inittab

                		# Cause the file to be re-examined
                		/sbin/telinit q
                		echo "2"			#timeout successfully handeled
                		echo timeout successfully handeled;
				exit 2 
        		fi
                else			#if no timeout, everything went as planned
                       	echo "0" 
                       	echo no timeout, everything went as planned;
			exit 0
                fi
       	fi

fi
if [ $VFLAG -eq 1 ]
then
        #Perform the activate function - first see if it is already activated
        grep_results=`/bin/grep startFNMD /etc/inittab`
        if [[ $grep_results == "" ]]
        then
                # No entry in /etc/inittab - should not happen
                echo 4;
		echo No entry in /etc/inittab - should not happen;
                exit 4
        fi

        first_char=`echo $grep_results | $CUT -c 1`
        if [[ $first_char == "f" ]]
        then
                # SNM software is activated already
                echo "1"
		echo SNM software is activated already;
                exit 1
        else
                # SNM software is de-activated - need to activate it
                # First remove the entry from /etc/inittab
                /bin/sed -e '/fnmd:/d' /etc/inittab > /tmp/hsc_tmp_inittab

                # Now add the uncommented entry and mv the file back
                echo "fnmd:2345:respawn:/opt/hsc/bin/startFNMD -V 1>/dev/null 2>&1" >> /tmp/hsc_tmp_inittab
                /bin/mv /tmp/hsc_tmp_inittab /etc/inittab

                # Cause the file to be re-examined
                /sbin/telinit q

                # Now we wait
                # Use end as the while loop ending indicator, up is the
                #      signal that the daemon is up, and count will track
                #      how many sleep 5's we do.  If we get to 60, that's
                #      five minutes, and that's too long.
                end=0
                up=0
                count=0
                while test $end -eq 0
                do
                        sleep 5
                        num_grep_lines=`/bin/ps -ef | /bin/grep -c "/opt/hsc/bin/fnmd"`
                        if [ $num_grep_lines -gt 4 ]
                        then
                                        let up=$up+1
                        fi
                        let  count=$count+1
                        if (($count == 60 || $up == 1))
                        then
                                end=1
                        fi
                done

                if (($count == 60))
                then
                        # We exited because 5 minutes are up
                        echo "2"
			echo fnmd exited because 5 minutes are up;
                        exit 2
                else
                        echo "0"
			echo threads were up within the 5 min time...ok;
                        exit 0
                fi
	fi
fi
# For -a, perform the activate SNM software function
if [ $AFLAG -eq 1 ]
then
	#Perform the activate function - first see if it is already activated
	grep_results=`/bin/grep startFNMD /etc/inittab`
	if [[ $grep_results == "" ]]
	then
		# No entry in /etc/inittab - should not happen
		echo 4;
		echo No entry in /etc/inittab - should not happen;
		exit 4
	fi

	first_char=`echo $grep_results | $CUT -c 1`
	if [[ $first_char == "f" ]]
	then
		# SNM software is activated already
		echo "1"
		echo SNM software is activated already;
		exit 1
	else
		# SNM software is de-activated - need to activate it
		# First remove the entry from /etc/inittab
		/bin/sed -e '/fnmd:/d' /etc/inittab > /tmp/hsc_tmp_inittab

		# Now add the uncommented entry and mv the file back
		echo "fnmd:2345:respawn:/opt/hsc/bin/startFNMD 1>/dev/null 2>&1" >> /tmp/hsc_tmp_inittab
		/bin/mv /tmp/hsc_tmp_inittab /etc/inittab

		# Set up the config file to be exec'ed
		/bin/rm -f /opt/hsc/data/SNMConfig
		echo "/opt/hsc/bin/chswnm.bash -r" > /opt/hsc/data/SNMConfig

		# Cause the file to be re-examined
		/sbin/telinit q

		# Now we wait
		# Use end as the while loop ending indicator, up is the
		#      signal that the daemon is up, and count will track
		#      how many sleep 5's we do.  If we get to 60, that's
		#      five minutes, and that's too long.
		end=0
		up=0
		count=0
		while test $end -eq 0
		do
			sleep 5
			num_grep_lines=`/bin/ps -ef | /bin/grep -c "/opt/hsc/bin/fnmd"`
			if [ $num_grep_lines -gt 4 ]
			then
					let up=$up+1
			fi
                        let  count=$count+1
                        if (($count == 60 || $up == 1))
			then
				end=1
                        fi
		done	

                if (($count == 60))
		then
			# We exited because 5 minutes are up
			echo "2"
			echo We exited because 5 minutes are up and daemon has not started;
			exit 2
		else
			echo "0"
			echo Threads came up within 5 minutes. Daemon is running OK.;
			exit 0
		fi
	fi
fi

# For -r, uncomment the /etc/inittab entry for fnmd
if [ $RFLAG -eq 1 ]
then
	# First remove the entry from /etc/inittab
	/bin/sed -e '/fnmd:/d' /etc/inittab > /tmp/hsc_tmp_inittab

	# Now add the uncommented entry and mv the file back
	echo "fnmd:2345:respawn:/opt/hsc/bin/startFNMD 1>/dev/null 2>&1" >> /tmp/hsc_tmp_inittab
	/bin/mv /tmp/hsc_tmp_inittab /etc/inittab

	# Cause the file to be re-examined
	#/sbin/telinit q
	echo 0;
	echo startFNMD entry in /etc/inittab uncommented successfully;
	exit 0
fi

# For -d, perform the de-activate SNM software function
if [ $DFLAG -eq 1 ]
then
	#Perform the de-activate function - first see if it is already de-activated
	grep_results=`/bin/grep startFNMD /etc/inittab`
	if [[ $grep_results == "" ]]
	then
		# No entry in /etc/inittab - should not happen
		echo 4;
		echo No entry in /etc/inittab - should not happen;
		exit 4
	fi

	first_char=`echo $grep_results | $CUT -c 1`
	if [[ $first_char == "#" ]]
	then
		# SNM software is de-activated already
		echo "1"
		echo SNM software is de-activated already;
		exit 1
	else
		# SNM software is activated - need to de-activate it
		# First remove the entry from /etc/inittab

                # BGB New. Stop fnmd with i_stub and wait.
                #/opt/hsc/bin/i_stub_FS fnm -k
                
		# First remove the entry from /etc/inittab
                /bin/sed -e '/^fnmd:/d' /etc/inittab > /tmp/hsc_tmp_inittab

                # Now add the commented entry and mv the file back
                echo "#fnmd:2345:respawn:/opt/hsc/bin/startFNMD 1>/dev/null 2>&1" >> /tmp/hsc_tmp_inittab
                /bin/mv /tmp/hsc_tmp_inittab /etc/inittab

                # Cause the file to be re-examined
                /sbin/telinit q

		# Now we wait
		# Use end as the while loop ending indicator, down is the
		#      signal that the daemon is down (0 threads), and count
		#      wil track how many sleep 5's we do.  If we get to 6, 
		#      that's thirty seconds, and that's too long.
		end=0
		down=0
		count=0
		while test $end -eq 0
		do
			sleep 5
			num_grep_lines=`/bin/ps -e | /bin/grep -c "/opt/hsc/bin/fnmd"`
			if [ $num_grep_lines -eq 0 ]
			then
					let down=$down+1
			fi
                        let  count=$count+1
                        if (($count == 6 || $down == 1))
			then
				end=1
                        fi
		done	

                if (($count == 6))
		then
			# We exited because 30 seconds are up
			exit_ret=2
		else
			exit_ret=0
		fi

		/bin/sed -e '/^fnmd:/d' /etc/inittab > /tmp/hsc_tmp_inittab

		# Now add the commented entry and mv the file back
		echo "#fnmd:2345:respawn:/opt/hsc/bin/startFNMD 1>/dev/null 2>&1" >> /tmp/hsc_tmp_inittab
		/bin/mv /tmp/hsc_tmp_inittab /etc/inittab

		# Set up the config file to be exec'ed
		/bin/rm -f /opt/hsc/data/SNMConfig
		echo "/opt/hsc/bin/chswnm.bash -q" > /opt/hsc/data/SNMConfig

		# Cause the file to be re-examined
		/sbin/telinit q
		echo "$exit_ret"
		echo fnmd has been deactivated successfully;
		exit $exit_ret
	fi
fi

exit 0
